<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/photos/types/album.proto

namespace Google\Photos\Types;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Information about albums that are shared. This information is only included
 * if you created the album, it is shared and you have the sharing scope.
 *
 * Generated from protobuf message <code>google.photos.types.ShareInfo</code>
 */
class ShareInfo extends \Google\Protobuf\Internal\Message
{
    /**
     * Options that control whether someone can add media items to, or comment on
     * a shared album.
     *
     * Generated from protobuf field <code>.google.photos.types.SharedAlbumOptions shared_album_options = 1;</code>
     */
    protected $shared_album_options = null;
    /**
     * A link to the shared Google Photos album. Anyone with the link can view the
     * contents of the album, so it should be treated with care.
     * The `shareableUrl` parameter is only returned if the album has link sharing
     * turned on. If a user is already joined to an album that isn't link-shared,
     * they can use the album's
     * [`productUrl`](https://developers.google.com/photos/library/reference/rest/v1/albums#Album)
     * to access it instead.
     * A `shareableUrl` is invalidated if the owner turns off link sharing in the
     * Google Photos app, or if the album is unshared.
     *
     * Generated from protobuf field <code>string shareable_url = 2;</code>
     */
    protected $shareable_url = '';
    /**
     * A token that is used to join, leave, or retrieve the details of a shared
     * album on behalf of a user who isn't the owner.
     * A `shareToken` is invalidated if the owner turns off link sharing in the
     * Google Photos app, or if the album is unshared.
     *
     * Generated from protobuf field <code>string share_token = 3;</code>
     */
    protected $share_token = '';
    /**
     * True if the user is joined to the album. This is always true for
     * the owner of the album.
     *
     * Generated from protobuf field <code>bool is_joined = 4;</code>
     */
    protected $is_joined = false;
    /**
     * True if the user owns the album.
     *
     * Generated from protobuf field <code>bool is_owned = 5;</code>
     */
    protected $is_owned = false;
    /**
     * True if the album can be joined by users.
     *
     * Generated from protobuf field <code>bool is_joinable = 6;</code>
     */
    protected $is_joinable = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Photos\Types\SharedAlbumOptions $shared_album_options
     *           Options that control whether someone can add media items to, or comment on
     *           a shared album.
     *     @type string $shareable_url
     *           A link to the shared Google Photos album. Anyone with the link can view the
     *           contents of the album, so it should be treated with care.
     *           The `shareableUrl` parameter is only returned if the album has link sharing
     *           turned on. If a user is already joined to an album that isn't link-shared,
     *           they can use the album's
     *           [`productUrl`](https://developers.google.com/photos/library/reference/rest/v1/albums#Album)
     *           to access it instead.
     *           A `shareableUrl` is invalidated if the owner turns off link sharing in the
     *           Google Photos app, or if the album is unshared.
     *     @type string $share_token
     *           A token that is used to join, leave, or retrieve the details of a shared
     *           album on behalf of a user who isn't the owner.
     *           A `shareToken` is invalidated if the owner turns off link sharing in the
     *           Google Photos app, or if the album is unshared.
     *     @type bool $is_joined
     *           True if the user is joined to the album. This is always true for
     *           the owner of the album.
     *     @type bool $is_owned
     *           True if the user owns the album.
     *     @type bool $is_joinable
     *           True if the album can be joined by users.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Photos\Types\Album::initOnce();
        parent::__construct($data);
    }

    /**
     * Options that control whether someone can add media items to, or comment on
     * a shared album.
     *
     * Generated from protobuf field <code>.google.photos.types.SharedAlbumOptions shared_album_options = 1;</code>
     * @return \Google\Photos\Types\SharedAlbumOptions|null
     */
    public function getSharedAlbumOptions()
    {
        return isset($this->shared_album_options) ? $this->shared_album_options : null;
    }

    public function hasSharedAlbumOptions()
    {
        return isset($this->shared_album_options);
    }

    public function clearSharedAlbumOptions()
    {
        unset($this->shared_album_options);
    }

    /**
     * Options that control whether someone can add media items to, or comment on
     * a shared album.
     *
     * Generated from protobuf field <code>.google.photos.types.SharedAlbumOptions shared_album_options = 1;</code>
     * @param \Google\Photos\Types\SharedAlbumOptions $var
     * @return $this
     */
    public function setSharedAlbumOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Photos\Types\SharedAlbumOptions::class);
        $this->shared_album_options = $var;

        return $this;
    }

    /**
     * A link to the shared Google Photos album. Anyone with the link can view the
     * contents of the album, so it should be treated with care.
     * The `shareableUrl` parameter is only returned if the album has link sharing
     * turned on. If a user is already joined to an album that isn't link-shared,
     * they can use the album's
     * [`productUrl`](https://developers.google.com/photos/library/reference/rest/v1/albums#Album)
     * to access it instead.
     * A `shareableUrl` is invalidated if the owner turns off link sharing in the
     * Google Photos app, or if the album is unshared.
     *
     * Generated from protobuf field <code>string shareable_url = 2;</code>
     * @return string
     */
    public function getShareableUrl()
    {
        return $this->shareable_url;
    }

    /**
     * A link to the shared Google Photos album. Anyone with the link can view the
     * contents of the album, so it should be treated with care.
     * The `shareableUrl` parameter is only returned if the album has link sharing
     * turned on. If a user is already joined to an album that isn't link-shared,
     * they can use the album's
     * [`productUrl`](https://developers.google.com/photos/library/reference/rest/v1/albums#Album)
     * to access it instead.
     * A `shareableUrl` is invalidated if the owner turns off link sharing in the
     * Google Photos app, or if the album is unshared.
     *
     * Generated from protobuf field <code>string shareable_url = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setShareableUrl($var)
    {
        GPBUtil::checkString($var, True);
        $this->shareable_url = $var;

        return $this;
    }

    /**
     * A token that is used to join, leave, or retrieve the details of a shared
     * album on behalf of a user who isn't the owner.
     * A `shareToken` is invalidated if the owner turns off link sharing in the
     * Google Photos app, or if the album is unshared.
     *
     * Generated from protobuf field <code>string share_token = 3;</code>
     * @return string
     */
    public function getShareToken()
    {
        return $this->share_token;
    }

    /**
     * A token that is used to join, leave, or retrieve the details of a shared
     * album on behalf of a user who isn't the owner.
     * A `shareToken` is invalidated if the owner turns off link sharing in the
     * Google Photos app, or if the album is unshared.
     *
     * Generated from protobuf field <code>string share_token = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setShareToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->share_token = $var;

        return $this;
    }

    /**
     * True if the user is joined to the album. This is always true for
     * the owner of the album.
     *
     * Generated from protobuf field <code>bool is_joined = 4;</code>
     * @return bool
     */
    public function getIsJoined()
    {
        return $this->is_joined;
    }

    /**
     * True if the user is joined to the album. This is always true for
     * the owner of the album.
     *
     * Generated from protobuf field <code>bool is_joined = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setIsJoined($var)
    {
        GPBUtil::checkBool($var);
        $this->is_joined = $var;

        return $this;
    }

    /**
     * True if the user owns the album.
     *
     * Generated from protobuf field <code>bool is_owned = 5;</code>
     * @return bool
     */
    public function getIsOwned()
    {
        return $this->is_owned;
    }

    /**
     * True if the user owns the album.
     *
     * Generated from protobuf field <code>bool is_owned = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setIsOwned($var)
    {
        GPBUtil::checkBool($var);
        $this->is_owned = $var;

        return $this;
    }

    /**
     * True if the album can be joined by users.
     *
     * Generated from protobuf field <code>bool is_joinable = 6;</code>
     * @return bool
     */
    public function getIsJoinable()
    {
        return $this->is_joinable;
    }

    /**
     * True if the album can be joined by users.
     *
     * Generated from protobuf field <code>bool is_joinable = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setIsJoinable($var)
    {
        GPBUtil::checkBool($var);
        $this->is_joinable = $var;

        return $this;
    }

}

