<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/photos/library/v1/photos_library.proto

namespace Google\Photos\Library\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * This filter allows you to return media items based on the content type.
 * It's possible to specify a list of categories to include, and/or a list of
 * categories to exclude. Within each list, the categories are combined with an
 * OR. <p>
 * The content filter `includedContentCategories`: [c1, c2, c3] would get media
 * items that contain (c1 OR c2 OR c3). <p>
 * The content filter `excludedContentCategories`: [c1, c2, c3] would NOT get
 * media items that contain (c1 OR c2 OR c3). <p>
 * You can also include some categories while excluding others, as in this
 * example: `includedContentCategories`: [c1, c2], `excludedContentCategories`:
 * [c3, c4] <p>
 * The previous example would get media items that contain (c1 OR c2) AND NOT
 * (c3 OR c4). A category that appears in `includedContentategories` must not
 * appear in `excludedContentCategories`.
 *
 * Generated from protobuf message <code>google.photos.library.v1.ContentFilter</code>
 */
class ContentFilter extends \Google\Protobuf\Internal\Message
{
    /**
     * The set of categories to be included in the media item search results.
     * The items in the set are ORed. There's a maximum of 10
     * `includedContentCategories` per request.
     *
     * Generated from protobuf field <code>repeated .google.photos.library.v1.ContentCategory included_content_categories = 1;</code>
     */
    private $included_content_categories;
    /**
     * The set of categories which are not to be included in the media item search
     * results. The items in the set are ORed. There's a maximum of 10
     * `excludedContentCategories` per request.
     *
     * Generated from protobuf field <code>repeated .google.photos.library.v1.ContentCategory excluded_content_categories = 2;</code>
     */
    private $excluded_content_categories;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int[]|\Google\Protobuf\Internal\RepeatedField $included_content_categories
     *           The set of categories to be included in the media item search results.
     *           The items in the set are ORed. There's a maximum of 10
     *           `includedContentCategories` per request.
     *     @type int[]|\Google\Protobuf\Internal\RepeatedField $excluded_content_categories
     *           The set of categories which are not to be included in the media item search
     *           results. The items in the set are ORed. There's a maximum of 10
     *           `excludedContentCategories` per request.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Photos\Library\V1\PhotosLibrary::initOnce();
        parent::__construct($data);
    }

    /**
     * The set of categories to be included in the media item search results.
     * The items in the set are ORed. There's a maximum of 10
     * `includedContentCategories` per request.
     *
     * Generated from protobuf field <code>repeated .google.photos.library.v1.ContentCategory included_content_categories = 1;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getIncludedContentCategories()
    {
        return $this->included_content_categories;
    }

    /**
     * The set of categories to be included in the media item search results.
     * The items in the set are ORed. There's a maximum of 10
     * `includedContentCategories` per request.
     *
     * Generated from protobuf field <code>repeated .google.photos.library.v1.ContentCategory included_content_categories = 1;</code>
     * @param int[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setIncludedContentCategories($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Photos\Library\V1\ContentCategory::class);
        $this->included_content_categories = $arr;

        return $this;
    }

    /**
     * The set of categories which are not to be included in the media item search
     * results. The items in the set are ORed. There's a maximum of 10
     * `excludedContentCategories` per request.
     *
     * Generated from protobuf field <code>repeated .google.photos.library.v1.ContentCategory excluded_content_categories = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExcludedContentCategories()
    {
        return $this->excluded_content_categories;
    }

    /**
     * The set of categories which are not to be included in the media item search
     * results. The items in the set are ORed. There's a maximum of 10
     * `excludedContentCategories` per request.
     *
     * Generated from protobuf field <code>repeated .google.photos.library.v1.ContentCategory excluded_content_categories = 2;</code>
     * @param int[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExcludedContentCategories($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Photos\Library\V1\ContentCategory::class);
        $this->excluded_content_categories = $arr;

        return $this;
    }

}

